package net.minecraft.src;

import java.util.*;
import net.minecraft.client.Minecraft;
import net.minecraft.src.forge.*;

public class ItemWand extends Item
{
	protected ItemWand(int i)
	{
		super(i);
		maxStackSize = 1;
		setMaxDamage(0xffffff);
	}

    public int getColorFromDamage(int i, int j)
    {
    	if(mod_ColoredBlocks.importing)
    	{
    		return 0xffffff;
    	}
        return ((mod_ColoredBlocks.redVal << 16) | (mod_ColoredBlocks.greenVal << 8)) | (mod_ColoredBlocks.blueVal);
    }

    public boolean func_46058_c()
    {
        return true;
    }

    public boolean hasEffect(ItemStack itemstack)
    {
        return mod_ColoredBlocks.importing;
    }

    public boolean isFull3D()
    {
        return true;
    }

    public ItemStack onItemRightClick(ItemStack itemstack, World world, EntityPlayer entityplayer)
    {
    	if(entityplayer.isSneaking())
		{
			initGui(entityplayer);
		}
        return itemstack;
    }

    public void initGui(EntityPlayer player)
    {
    	ModLoader.OpenGUI(player, new GuiBlockColoredMain(player));
    }

	public boolean onItemUse(ItemStack itemstack, EntityPlayer entityplayer, World world, int i, int j, int k, int l)
	{
		Random random = new Random();
		if(entityplayer.isSneaking())
		{
			return false;
		}

		int k1 = world.getBlockId(i, j, k);
		int meta = world.getBlockMetadata(i, j, k);
		int newid = mod_ColoredBlocks.coloredblockid;
		int redVal = mod_ColoredBlocks.redVal;
	    int greenVal = mod_ColoredBlocks.greenVal;
	    int blueVal = mod_ColoredBlocks.blueVal;
	    int oldRed = mod_ColoredBlocks.redVal;
	    int oldGreen = mod_ColoredBlocks.greenVal;
	    int oldBlue = mod_ColoredBlocks.blueVal;
	    boolean successful = false;
	    if(mod_ColoredBlocks.importing)
	    {
	    	redVal = 0x00;
	    	greenVal = 0x00;
	    	blueVal = 0x00;
	    }
		if( world.getBlockTileEntity(i, j, k) == null && k1 != 0 && k1 != newid && Block.blocksList[k1] != null && (Block.blocksList[k1].isOpaqueCube())) 
		{
			world.setBlockAndMetadata(i, j, k, newid, meta);
			TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
	        if(tile != null)
	        {
	            tile.setBlock(k1, world, i, j, k, meta);
				tile.setRed(redVal);
				tile.setGreen(greenVal);
				tile.setBlue(blueVal);
	            world.markBlockNeedsUpdate(i, j, k);
	            entityplayer.swingItem();
	            successful = true;
	            for(int ll = 0; ll<10+random.nextInt(5);ll++)
	            {
	            	mod_ColoredBlocks.mcInst.effectRenderer.addEffect(new EntitySpellParticleColorFX(world, i+random.nextFloat(), j+random.nextFloat(), k+random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), redVal, greenVal, blueVal));
	            }
	        }
		}
		else
		if(k1 == newid)
		{
			TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
			if(tile != null)
			{
				oldRed = tile.redValue;
				oldGreen = tile.greenValue;
				oldBlue = tile.blueValue;
				tile.setRed(redVal);
				tile.setGreen(greenVal);
				tile.setBlue(blueVal);
				world.markBlockNeedsUpdate(i, j, k);
	            entityplayer.swingItem();
	            successful = true;
	            for(int ll = 0; ll<10+random.nextInt(5);ll++)
	            {
	            	mod_ColoredBlocks.mcInst.effectRenderer.addEffect(new EntitySpellParticleColorFX(world, i+random.nextFloat(), j+random.nextFloat(), k+random.nextFloat(), random.nextFloat(), random.nextFloat(), random.nextFloat(), redVal, greenVal, blueVal));
	            }
			}
		}
		if(mod_ColoredBlocks.importing && successful)
        {
        	if(!mod_ColoredBlocks.firstset && !mod_ColoredBlocks.secondset)
        	{
        		mod_ColoredBlocks.firstset = true;
        		mod_ColoredBlocks.xF = i;
        		mod_ColoredBlocks.yF = j;
        		mod_ColoredBlocks.zF = k;
        		mod_ColoredBlocks.fID = k1;
        		if(k1 == newid)
        		{
        			TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
					if(tile != null)
					{
						mod_ColoredBlocks.fRed = oldRed;
						mod_ColoredBlocks.fGreen = oldGreen;
						mod_ColoredBlocks.fBlue = oldBlue;
					}
        		}
        		mod_ColoredBlocks.mcInst.ingameGUI.addChatMessage("Place a second point to determine x orientation.");
        	}
        	else
        	if(mod_ColoredBlocks.firstset && !mod_ColoredBlocks.secondset)
        	{
        		mod_ColoredBlocks.secondset = true;
        		mod_ColoredBlocks.xS = i;
        		mod_ColoredBlocks.yS = j;
        		mod_ColoredBlocks.zS = k;
        		mod_ColoredBlocks.sID = k1;
        		if(k1 == newid)
        		{
        			TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
					if(tile != null)
					{
						mod_ColoredBlocks.sRed = oldRed;
						mod_ColoredBlocks.sGreen = oldGreen;
						mod_ColoredBlocks.sBlue = oldBlue;
					}
        		}
        		mod_ColoredBlocks.xDirect = mod_ColoredBlocks.getxDirection(world);
        		if(mod_ColoredBlocks.xDirect != 0)
        		{
        			mod_ColoredBlocks.mcInst.ingameGUI.addChatMessage("Place a third point to determine y orientation.");
        		}
        	}
        	else
        	if(mod_ColoredBlocks.firstset && mod_ColoredBlocks.secondset)
        	{
        		mod_ColoredBlocks.thirdset = true;
        		mod_ColoredBlocks.xT = i;
        		mod_ColoredBlocks.yT = j;
        		mod_ColoredBlocks.zT = k;
        		mod_ColoredBlocks.tID = k1;
        		if(k1 == newid)
        		{
        			TileEntityBlockColored tile = (TileEntityBlockColored)world.getBlockTileEntity(i, j, k);
					if(tile != null)
					{
						mod_ColoredBlocks.tRed = oldRed;
						mod_ColoredBlocks.tGreen = oldGreen;
						mod_ColoredBlocks.tBlue = oldBlue;
					}
        		}
        		mod_ColoredBlocks.yDirect = mod_ColoredBlocks.getyDirection(world);
        		if(mod_ColoredBlocks.yDirect != 0)
        		{
        			mod_ColoredBlocks.initImport(world, entityplayer);
	        	}
        	}
        }
		return true;
	}
}